﻿using OpenAI.Chat;

namespace Robotless.Modules.Agenting;

public interface IAgentMemory : IDisposable, IEnumerable<ChatMessage>
{
    /// <summary>
    /// Add a message to the memory.
    /// </summary>
    void Add(ChatMessage message);

    /// <summary>
    /// Remove a message from the memory.
    /// </summary>
    void Remove(ChatMessage message);

    /// <summary>
    /// Clear all messages within this memory.
    /// </summary>
    void Clear();
}

public static class AgentMemoryExtensions
{
    public static AgentSystemMessage AddSystemMessage(this IAgentMemory memory, string content)
    {
        var message = new AgentSystemMessage(content);
        memory.Add(message);
        return message;
    }
    
    public static AgentUserMessage AddUserMessage(this IAgentMemory memory, string content)
    {
        var message = new AgentUserMessage(content);
        memory.Add(message);
        return message;
    }
    
    public static AgentAssistantMessage AddAssistantMessage(this IAgentMemory memory, string content)
    {
        var message = new AgentAssistantMessage(content);
        memory.Add(message);
        return message;
    }
}