﻿using System.Diagnostics;
using OpenAI.Chat;

namespace Robotless.Modules.Agenting;

public interface IAgentMessage
{
    string Text { get; set; }
}

[DebuggerDisplay("{Text}", Name = "Assistant")]
public class AgentAssistantMessage : AssistantChatMessage, IAgentMessage
{
    public AgentAssistantMessage(string text) : base(text)
    {}
    
    public AgentAssistantMessage(ChatCompletion completion) : base(completion)
    {}
    
    public string Text 
    { 
        get => Content.Count > 0 ? Content[0].Text : string.Empty;
        set
        {
            if (Content.Count > 0)
                Content.Clear();
            Content.Add(ChatMessageContentPart.CreateTextPart(value));
        }
    }
}

[DebuggerDisplay("{Text}", Name = "User")]
public class AgentUserMessage(string text) : UserChatMessage(text), IAgentMessage
{
    public string Text 
    { 
        get => Content.Count > 0 ? Content[0].Text : string.Empty;
        set
        {
            if (Content.Count > 0)
                Content.Clear();
            Content.Add(ChatMessageContentPart.CreateTextPart(value));
        }
    }
}

[DebuggerDisplay("{Text}", Name = "System")]
public class AgentSystemMessage(string text) : SystemChatMessage(text), IAgentMessage
{
    public string Text
    {
        get => Content.Count > 0 ? Content[0].Text : string.Empty;
        set
        {
            if (Content.Count > 0)
                Content.Clear();
            Content.Add(ChatMessageContentPart.CreateTextPart(value));
        }
    }
}

[DebuggerDisplay("{Text}", Name = "Tool")]
public class AgentToolMessage(string toolCallId, string text) : 
    ToolChatMessage(toolCallId, text), IAgentMessage
{
    public string Text
    {
        get => Content.Count > 0 ? Content[0].Text : string.Empty;
        set
        {
            if (Content.Count > 0)
                Content.Clear();
            Content.Add(ChatMessageContentPart.CreateTextPart(value));
        }
    }
}