﻿using OpenAI.Chat;

namespace Robotless.Modules.Agenting.Utilities;

public static class ChatMessageExtensions
{
    /// <summary>
    /// Get the content of the first content part of the specified message.
    /// </summary>
    public static string GetContent(this ChatMessage message)
        => message.Content.Count > 0 ? message.Content[0].Text : string.Empty;

    /// <summary>
    /// Set the content of the first content part of the specified message.
    /// </summary>
    public static void SetContent(this ChatMessage message, string content)
    {
        if (message.Content.Count > 0)
            message.Content.Clear();
        message.Content.Add(ChatMessageContentPart.CreateTextPart(content));
    }
}