using Robotless.Modules.OpenAi.Chat;
using Robotless.Modules.AiAgent.Messages;

namespace Robotless.Modules.AiAgent;

public interface IAgent
{
    /// <summary>
    /// Chat with the agent.
    /// The request message and the response message will be automatically added to the memory.
    /// </summary>
    /// <param name="request">Request message to send to the agent.</param>
    /// <param name="memory">Memory of chat history to use.</param>
    /// <param name="options">Chat options.</param>
    /// <param name="tools">Tools to use in this chat.</param>
    /// <param name="cancellation">Token to cancel this chat.</param>
    /// <returns>Response from the agent.</returns>
    public Task<AgentResponseMessage> Chat(
        AgentRequestMessage request, IAgentMemory memory,
        ChatCompletionOptions? options = null, 
        IReadOnlyDictionary<string, IAgentTool>? tools = null,
        CancellationToken cancellation = default);
}