using Robotless.Modules.OpenAi.Chat;
using Robotless.Modules.AiAgent.Messages;

namespace Robotless.Modules.AiAgent;

public interface IAgentMemory : IEnumerable<ChatMessage>
{
    /// <summary>
    /// Add a message to the memory.
    /// </summary>
    void Add(ChatMessage message);

    /// <summary>
    /// Remove a message from the memory.
    /// </summary>
    void Remove(ChatMessage message);

    /// <summary>
    /// Clear all messages within this memory.
    /// </summary>
    void Clear();
}


public static class AgentMemoryExtensions
{
    public static AgentSystemMessage AddSystemMessage(this IAgentMemory memory, string content)
    {
        var message = new AgentSystemMessage(content);
        memory.Add(message);
        return message;
    }
    
    public static AgentRequestMessage AddUserMessage(this IAgentMemory memory, string content)
    {
        var message = new AgentRequestMessage(content);
        memory.Add(message);
        return message;
    }
    
    public static AgentResponseMessage AddAssistantMessage(this IAgentMemory memory, string content)
    {
        var message = new AgentResponseMessage(content);
        memory.Add(message);
        return message;
    }
}