﻿using Robotless.Modules.OpenAi.Chat;
using Robotless.Kernel;

namespace Robotless.Modules.AiAgent;

public interface IAgentTool : IIdentifiable
{
    /// <summary>
    /// Descriptor for this tool.
    /// </summary>
    ChatTool Descriptor { get; }
    
    /// <summary>
    /// Invoke this tool.
    /// </summary>
    /// <param name="arguments">Arguments JSON in text.</param>
    /// <returns>Result in text.</returns>
    string Invoke(string arguments);
}