using System.Diagnostics;
using Robotless.Modules.OpenAi.Chat;

namespace Robotless.Modules.AiAgent.Messages;

[DebuggerDisplay("{Text}", Name = "Request")]
public class AgentRequestMessage(string text) : UserChatMessage(text), IAgentMessage
{
    public virtual string Text
    { 
        get => Content.Count > 0 ? Content[0].Text : string.Empty;
        set
        {
            if (Content.Count > 0)
                Content.Clear();
            Content.Add(ChatMessageContentPart.CreateTextPart(value));
        }
    }
}