using System.Diagnostics;
using Robotless.Modules.OpenAi.Chat;

namespace Robotless.Modules.AiAgent.Messages;

[DebuggerDisplay("{Text}", Name = "Response")]
public class AgentResponseMessage : AssistantChatMessage, IAgentMessage
{
    public AgentResponseMessage(string text) : base(text)
    {}

    public AgentResponseMessage(ChatCompletion completion) : base(completion)
    {
        Completion = completion;
        RefusalMessage = completion.Refusal;
        TokenUsage = completion.Usage;
    }

    public ChatCompletion? Completion { get; }
    
    /// <summary>
    /// The refusal message generated by the model.
    /// </summary>
    public string? RefusalMessage { get; }

    /// <summary>
    /// The token usage for this completion.
    /// </summary>
    public ChatTokenUsage? TokenUsage { get; } 
    
    public virtual string Text 
    { 
        get => Content.Count > 0 ? Content[0].Text : string.Empty;
        set
        {
            if (Content.Count > 0)
                Content.Clear();
            Content.Add(ChatMessageContentPart.CreateTextPart(value));
        }
    }
}