using System.Diagnostics;
using Robotless.Modules.OpenAi.Chat;

namespace Robotless.Modules.AiAgent.Messages;

[DebuggerDisplay("{Text}", Name = "System")]
public class AgentSystemMessage(string text) : SystemChatMessage(text), IAgentMessage
{
    public virtual string Text
    {
        get => Content.Count > 0 ? Content[0].Text : string.Empty;
        set
        {
            if (Content.Count > 0)
                Content.Clear();
            Content.Add(ChatMessageContentPart.CreateTextPart(value));
        }
    }
}