﻿namespace Robotless.Modules.Mocking.Learning.Metrics;

public class CorrectnessMetrics<TResult> : TrainerMetrics<TResult>
{
    public bool IsCorrect { get; private set; }

    public Func<TResult, TResult, bool> Comparer { get; }

    public CorrectnessMetrics(Func<TResult, TResult, bool>? comparer = null)
    {
        Comparer = comparer ?? DefaultComparer;
        
        return;
        
        bool DefaultComparer(TResult expectedResult, TResult actualResult)
            => expectedResult != null ? expectedResult.Equals(actualResult) : actualResult == null;
    }
    
    public override void Report(TResult expectedResult, TResult actualResult)
    {
        IsCorrect = Comparer(expectedResult, actualResult);
    }

    public override string ToText()
    {
        return IsCorrect ? "Correct" : "Wrong";
    }

    public override string ToMarkup()
    {
        return IsCorrect ? "[green]Correct[/]" : "[red]Wrong[/]";
    }
}

public static class CorrectnessMetricsExtensions
{
    public static Dictionary<string,Func<TrainerMetrics<TResult>>> UseCorrectness<TResult>(
        this Dictionary<string,Func<TrainerMetrics<TResult>>> metrics, Func<TResult, TResult, bool>? comparer = null)
    {
        metrics["Correctness"] = () => new CorrectnessMetrics<TResult>(comparer);
        return metrics;
    }
}