﻿namespace Robotless.Modules.Mocking.Learning.Metrics;

public class LambdaValueMetrics<TResult>(Func<TResult, TResult, double> metrics) : TrainerMetrics<TResult>
{
    public double Value { get; private set; }

    public override void Report(TResult expectedResult, TResult actualResult)
    {
        Value = metrics(expectedResult, actualResult);
    }

    public override string ToText() => Value.ToString("F4");
}

public static class LambdaValueMetricsExtensions
{
    public static Dictionary<string,Func<TrainerMetrics<TResult>>> UseLambdaMetrics<TResult>(
        this Dictionary<string,Func<TrainerMetrics<TResult>>> metrics, 
        string name, Func<TResult, TResult, double> functor)
    {
        metrics[name] = () => new LambdaValueMetrics<TResult>(functor);
        return metrics;
    }
}