﻿using System.Numerics;

namespace Robotless.Modules.Mocking.Learning.Metrics;

public class MeanAbsoluteErrorMetrics<TResult> : TrainerMetrics<TResult> where TResult : INumber<TResult>
{
    private int _count;
    private double _summary;

    public double Error => _summary / _count;

    public override void Report(TResult expectedResult, TResult actualResult)
    {
        ++_count;
        _summary += Math.Abs(Convert.ToDouble(expectedResult - actualResult));
    }

    public override string ToText()
    {
        return Error.ToString("F4");
    }
}


public static class MeanAbsoluteErrorMetricsExtensions
{
    public static Dictionary<string,Func<TrainerMetrics<TResult>>> UseMeanAbsoluteError<TResult>(
        this Dictionary<string,Func<TrainerMetrics<TResult>>> metrics) where TResult : INumber<TResult>
    {
        metrics["MeanError"] = () => new MeanAbsoluteErrorMetrics<TResult>();
        return metrics;
    }
}