﻿using System.Numerics;

namespace Robotless.Modules.Mocking.Learning.Metrics;

public class MedianAbsoluteErrorMetrics<TResult> : TrainerMetrics<TResult> where TResult : INumber<TResult>
{
    private readonly List<double> _errors = new();

    public double MedianError
    {
        get
        {
            if (_errors.Count == 0)
                return 0;
            return _errors[_errors.Count / 2];
        }
    }

    public override void Report(TResult expectedResult, TResult actualResult)
    {
        var error = Math.Abs(Convert.ToDouble(expectedResult - actualResult));
        _errors.Add(error);
        _errors.Sort();
    }

    public override string ToText()
    {
        return MedianError.ToString("F4");
    }
}


public static class MedianAbsoluteErrorMetricsExtensions
{
    public static Dictionary<string,Func<TrainerMetrics<TResult>>> UseMedianAbsoluteError<TResult>(
        this Dictionary<string,Func<TrainerMetrics<TResult>>> metrics) where TResult : INumber<TResult>
    {
        metrics["MedianAbsoluteError"] = () => new MedianAbsoluteErrorMetrics<TResult>();
        return metrics;
    }
}