﻿using System.Numerics;

namespace Robotless.Modules.Mocking.Learning.Metrics;

public class RootMeanSquareErrorMetrics<TResult> : TrainerMetrics<TResult> where TResult: INumber<TResult>
{
    private int _count;
    private double _summary;

    public double Error => Math.Sqrt(_summary / _count);
    
    public override void Report(TResult expectedResult, TResult actualResult)
    {
        var difference = Convert.ToDouble(expectedResult) - Convert.ToDouble(actualResult);
        _summary += difference * difference;
        ++_count;
    }

    public override string ToText() => Error.ToString("F4");
}

public static class OverallRootMeanSquareErrorMetricsExtensions
{
    public static Dictionary<string,Func<TrainerMetrics<TResult>>> UseRootMeanSquareError<TResult>(
        this Dictionary<string,Func<TrainerMetrics<TResult>>> metrics) where TResult : INumber<TResult>
    {
        metrics["RootMeanSquareError"] = () => new RootMeanSquareErrorMetrics<TResult>();
        return metrics;
    }
}