﻿using System.Numerics;

namespace Robotless.Modules.Mocking.Learning.Metrics;

public class RootMeanSquareLogErrorMetrics<TResult> : TrainerMetrics<TResult> where TResult: INumber<TResult>
{
    private int _count;
    private double _summary;

    public double Error => Math.Sqrt(_summary / _count);
    
    public override void Report(TResult expectedResult, TResult actualResult)
    {
        var expected = Convert.ToDouble(expectedResult);
        var actual = Convert.ToDouble(actualResult);
        var difference = Math.Log(1.0 + expected) - Math.Log(1.0 + actual);
        _summary += difference * difference;
        ++_count;
    }

    public override string ToText() => Error.ToString("F4");
}

public static class OverallRootMeanSquareLogErrorMetricsExtensions
{
    public static Dictionary<string,Func<TrainerMetrics<TResult>>> UseRootMeanSquareLogError<TResult>(
        this Dictionary<string,Func<TrainerMetrics<TResult>>> metrics) where TResult : INumber<TResult>
    {
        metrics["RootMeanSquareLogError"] = () => new RootMeanSquareLogErrorMetrics<TResult>();
        return metrics;
    }
}