﻿using System.Numerics;

namespace Robotless.Modules.Mocking.Learning.Metrics;

public class StandardDeviationMetrics<TResult> : TrainerMetrics<TResult> where TResult: INumber<TResult>
{
    public double Deviation { get; private set; }
    
    public override void Report(TResult expectedResult, TResult actualResult)
    {
        var difference = Convert.ToDouble(expectedResult) - Convert.ToDouble(actualResult);
        Deviation = Math.Sqrt(difference * difference);
    }

    public override string ToText() => Deviation.ToString("F4");
}

public static class RootMeanSquareErrorMetricsExtensions
{
    public static Dictionary<string,Func<TrainerMetrics<TResult>>> UseStandardDeviation<TResult>(
        this Dictionary<string,Func<TrainerMetrics<TResult>>> metrics) where TResult : INumber<TResult>
    {
        metrics["StandardDeviation"] = () => new StandardDeviationMetrics<TResult>();
        return metrics;
    }
}