﻿using Robotless.Modules.AiAgent;
using Robotless.Modules.AiAgent.Messages;

namespace Robotless.Modules.Mocking.Learning;

public static class RemarksCompressor
{
    /// <summary>
    /// This methods will ask the agent to summarize remarks of previous input-output pairs,
    /// </summary>
    /// <param name="mock">The function to compress.</param>
    /// <param name="cancellation">Token to cancel this operation/</param>
    /// <returns>Summarized remarks.</returns>
    public static async Task<string> Compress(MockFunction mock, CancellationToken cancellation = default)
    {
        using (mock.NewMemoryScope(out var memory))
        {
            var message = new AgentRequestMessage(
                $"""
                 In previous invocations you have made some mistakes and remarks to not make them again.
                 Now summarize these notes to help your future self to avoid these mistakes and maximize your accuracy.
                 You can include specific examples and reasoning in the summary.
                 """);
            var response = await mock.ReflectionAgent.Chat(
                message, memory, cancellation: cancellation);
            
            mock.Memory.ReportTokenUsage(response.TokenUsage?.InputTokenCount, "Compression.Input");
            mock.Memory.ReportTokenUsage(response.TokenUsage?.OutputTokenCount, "Compression.Output");

            return response.Text;
        }
    }
}