﻿namespace Robotless.Modules.Mocking.Learning;

public enum TrainerInvocationFlag : int
{
    Unknown = 0,
    /// <summary>
    /// Mock function has not reflected on this invocation.
    /// </summary>
    Passed = 1,
    /// <summary>
    /// Mock function has reflected on this invocation.
    /// </summary>
    Failed = 2,
}

public static class TrainerInvocationFlagExtensions
{
    public static TrainerInvocationFlag GetTrainerFlag(this MockInvocation invocation)
    {
        return invocation["Flag"] is TrainerInvocationFlag flag ? flag : TrainerInvocationFlag.Unknown;
    }
    
    public static void SetTrainerFlag(this MockInvocation invocation, TrainerInvocationFlag flag)
    {
        invocation["Flag"] = flag;
    }
    
    public static bool IsPassed(this MockInvocation invocation)
    {
        return invocation["Flag"] is TrainerInvocationFlag.Passed;
    }

    public static bool IsFailed(this MockInvocation invocation)
    {
        return invocation["Flag"] is TrainerInvocationFlag.Failed;
    }
}