﻿namespace Robotless.Modules.Mocking.Learning;

/// <summary>
/// The metrics that the trainer will use.
/// Its <see cref="TrainerMetrics{TResult}.ToString()"/> method will be used
/// to acquire the metrics value formatted in string.
/// </summary>
/// <typeparam name="TResult">The type of the result from mock functions.</typeparam>
public abstract class TrainerMetrics<TResult>
{
    /// <summary>
    /// Trainer will invoke this method to report the result.
    /// </summary>
    /// <param name="expectedResult">Expected result from the data entry.</param>
    /// <param name="actualResult">Actual result from the mock function.</param>
    public abstract void Report(TResult expectedResult, TResult actualResult);

    public abstract string ToText();

    public virtual string ToMarkup() => ToText();
}