﻿using System.Reflection;
using JetBrains.Annotations;
using Robotless.Modules.AiAgent;
using Robotless.Modules.Documenting;
using Robotless.Modules.Mocking.Utilities;
using Robotless.Modules.Serializing;

namespace Robotless.Modules.Mocking;

public class MockDelegate<TDelegate> : MockDelegate where TDelegate : Delegate
{
    public MockDelegate(IAgent executor, IAgent? reflector, IAgent? generator,
        ISerializationProvider serialization, IDocumentation? documentation = null) : base(typeof(TDelegate), executor,
        reflector, generator, serialization, documentation)
    {
        var redirectorType = InvokerRedirectorGenerator.GetRedirectorType(typeof(TDelegate));
        var redirector = Activator.CreateInstance(redirectorType, this)!;
        var invokeMethod = redirectorType.GetMethod("MockInvoke")!;
        Invoke = invokeMethod.CreateDelegate<TDelegate>(redirector);

        _exampleRedirectorType = ExampleRedirectorGenerator.GetRedirectorType(typeof(TDelegate));
        _exampleRedirectorMethod = _exampleRedirectorType.GetMethod("MockInvoke")!;
    }
    
    [PublicAPI]
    public new TDelegate Invoke { get; }
    
    public TDelegate Example(object result, string remarks)
    {
        var redirector = Activator.CreateInstance(_exampleRedirectorType, 
            this, result, remarks)!;
        return _exampleRedirectorMethod.CreateDelegate<TDelegate>(redirector);
    }
    
    public static implicit operator TDelegate(MockDelegate<TDelegate> mock) => mock.Invoke;
    
    private readonly Type _exampleRedirectorType;
    
    private readonly MethodInfo _exampleRedirectorMethod;
}