﻿using Robotless.Modules.OpenAi.Chat;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Mocking.Utilities;

public static class ResponseSchemaFactory
{
    public static ChatResponseFormat ToResponseFormat(this ObjectSchemaDocument schema, string name, 
        string? description = null, bool strict = true)
    {
        return ChatResponseFormat.CreateJsonSchemaFormat(name, 
            BinaryData.FromString(schema.ToString()),
            description, jsonSchemaIsStrict: strict);
    }
}