using System;

namespace Robotless.Modules.OpenAi.Chat;

/// <summary>
/// Represents an <c>assistant</c> call against a supplied <see cref="ChatFunction"/> that is needed by the
/// model to continue the logical conversation.
/// </summary>
/// <remarks>
/// <para>
///     Note that <c>functions</c> are deprecated in favor of <c>tools</c> and using <see cref="ChatTool"/>
///     instances with <see cref="ChatCompletionOptions.Tools"/> will enable the use of <c>tool_calls</c> via
///     <see cref="ChatCompletion.ToolCalls"/> instead of this type.
/// </para>
/// <para>
///     The model makes a <c>function_call</c> in response to evaluation of supplied <c>name></c> and
///     <c>description</c> information in <c>functions</c> and is resolved by providing a new
///     <see cref="FunctionChatMessage"/> with matching functioning output on a subsequent chat completion
///     request.
/// </para>
/// </remarks>
[Obsolete($"This class is obsolete. Please use {nameof(ChatToolCall)} instead.")]
[CodeGenModel("ChatCompletionRequestAssistantMessageFunctionCall")]
[CodeGenSerialization(nameof(FunctionArguments), SerializationValueHook = nameof(SerializeFunctionArgumentsValue), DeserializationValueHook = nameof(DeserializeFunctionArgumentsValue))]
public partial class ChatFunctionCall
{
    // CUSTOM: Renamed.
    /// <summary> The name of the function to call. </summary>
    [CodeGenMember("Name")]
    public string FunctionName { get; }

    // CUSTOM:
    // - Renamed.
    // - Changed type from string to BinaryData.
    /// <summary> 
    /// The arguments to call the function with, as generated by the model in JSON format. Note
    /// that the model does not always generate valid JSON, and may hallucinate parameters not
    /// defined by your function schema. Validate the arguments in your code before calling your
    /// function.
    /// </summary>
    [CodeGenMember("Arguments")]
    public BinaryData FunctionArguments { get; }
}
