﻿using System.Collections.Generic;

namespace Robotless.Modules.OpenAi.Chat;


[CodeGenModel("ChatCompletionResponseMessage")]
[CodeGenSuppress("InternalChatCompletionResponseMessage", typeof(IEnumerable<ChatMessageContentPart>))]
[CodeGenSerialization(nameof(Content), SerializationValueHook = nameof(SerializeContentValue), DeserializationValueHook = nameof(DeserializeContentValue))]
internal partial class InternalChatCompletionResponseMessage
{
    // CUSTOM: Changed type from InternalChatCompletionResponseMessageRole.
    /// <summary> The role of the author of this message. </summary>
    [CodeGenMember("Role")]
    public ChatMessageRole Role { get; } = ChatMessageRole.Assistant;

    // CUSTOM: Changed type from string.
    /// <summary> The contents of the message. </summary>
    [CodeGenMember("Content")]
    public ChatMessageContent Content { get; }

    // CUSTOM: Changed type from InternalChatCompletionResponseMessageFunctionCall.
    /// <summary> Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model. </summary>
    [CodeGenMember("FunctionCall")]
    public ChatFunctionCall FunctionCall { get; }
}
