namespace Robotless.Modules.OpenAi.Chat;

using System;

/// <summary> A streaming update representing part of a tool call made by the model. </summary>
[CodeGenModel("ChatCompletionMessageToolCallChunk")]
[CodeGenSuppress("StreamingChatToolCallUpdate", typeof(int))]
public partial class StreamingChatToolCallUpdate
{
    // CUSTOM: Made internal.
    [CodeGenMember("Function")]
    internal InternalChatCompletionMessageToolCallChunkFunction Function { get; }

    // CUSTOM:
    // - Renamed.
    // - Changed type from string.
    /// <summary> The kind of tool.Currently, only<see cref="ChatToolCallKind.Function"/> is supported. </summary>
    [CodeGenMember("Type")]
    public ChatToolCallKind Kind { get; } = ChatToolCallKind.Function;

    // CUSTOM: Renamed.
    /// <summary>
    /// The unique identifier of the tool call being streamed, as used with e.g.
    /// <see cref="ChatToolCall.CreateFunctionToolCall(string, string, string)"/> or
    /// <see cref="ToolChatMessage.ToolChatMessage(string, string)"/>.
    /// </summary>
    [CodeGenMember("Id")]
    public string ToolCallId { get; }

    /// <summary>
    /// The name of the the tool that the streaming tool call requests invocation of.
    /// </summary>
    public string FunctionName => Function?.Name;

    // CUSTOM: Spread.
    /// <summary> 
    ///     The update to the arguments that the model is calling the function with, which are generated by the model
    ///     in JSON format. As part of a streaming response, the arguments are chunked and streamed across streaming
    ///     updates, and must therefore be accumulated in order to reconstruct them. Note that the model does not
    ///     always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate
    ///     the arguments in your code before calling your function.
    /// </summary>
    public BinaryData FunctionArgumentsUpdate => Function?.Arguments;
}
