using System;

namespace Robotless.Modules.OpenAi.Moderations;

/// <summary> The kinds of inputs that <see cref="ModerationCategory.Score"/> is applicable to. </summary>
[Flags]
[CodeGenModel("ModerationAppliedInputType")]
internal enum ModerationApplicableInputKinds : int
{
    None = 0,

    Other = 1 << 0,

    [CodeGenMember("Text")]
    Text = 1 << 1,

    [CodeGenMember("Image")]
    Image = 1 << 2,
}