using Robotless.Modules.OpenAi.Embeddings;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Robotless.Modules.OpenAi;

[CodeGenModel("OpenAIModelFactory")]
internal static partial class OpenAIModelFactory
{
    /// <summary> Initializes a new instance of <see cref="Embeddings.OpenAIEmbeddingCollection"/>. </summary>
    /// <param name="data"> The list of embeddings generated by the model. </param>
    /// <param name="model"> The name of the model used to generate the embedding. </param>
    /// <param name="usage"> The usage information for the request. </param>
    /// <returns> A new <see cref="Embeddings.OpenAIEmbeddingCollection"/> instance for mocking. </returns>
    public static OpenAIEmbeddingCollection OpenAIEmbeddingCollection(IEnumerable<OpenAIEmbedding> data = null, EmbeddingTokenUsage usage = null, string model = null)
    {
        data ??= new List<OpenAIEmbedding>();

        return new OpenAIEmbeddingCollection(data?.ToList(), model, InternalCreateEmbeddingResponseObject.List, usage, serializedAdditionalRawData: null);
    }

    /// <summary> Initializes a new instance of <see cref="Embeddings.OpenAIEmbedding"/>. </summary>
    /// <param name="index"> The index of the embedding in the list of embeddings. </param>
    /// <param name="vector">
    /// The embedding vector, which is a list of floats. The length of vector depends on the model as
    /// listed in the [embedding guide](/docs/guides/embeddings).
    /// </param>
    /// <returns> A new <see cref="Embeddings.OpenAIEmbedding"/> instance for mocking. </returns>
    public static OpenAIEmbedding OpenAIEmbedding(ReadOnlyMemory<float> vector = default, int index = default)
    {
        // TODO: Vector must be converted to base64-encoded string.
        return new OpenAIEmbedding(index, BinaryData.FromObjectAsJson(vector), InternalEmbeddingObject.Embedding, serializedAdditionalRawData: null);
    }

}
