// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Text.Json;
using Robotless.Modules.OpenAi.FineTuning;

namespace Robotless.Modules.OpenAi.Chat
{
    [PersistableModelProxy(typeof(InternalUnknownChatMessage))]
    public partial class ChatMessage : IJsonModel<ChatMessage>
    {
        ChatMessage IJsonModel<ChatMessage>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChatMessage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ChatMessage)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeChatMessage(document.RootElement, options);
        }

        internal static ChatMessage DeserializeChatMessage(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("role", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case null: return InternalFineTuneChatCompletionRequestAssistantMessage.DeserializeInternalFineTuneChatCompletionRequestAssistantMessage(element, options);
                    case "assistant": return AssistantChatMessage.DeserializeAssistantChatMessage(element, options);
                    case "function": return FunctionChatMessage.DeserializeFunctionChatMessage(element, options);
                    case "system": return SystemChatMessage.DeserializeSystemChatMessage(element, options);
                    case "tool": return ToolChatMessage.DeserializeToolChatMessage(element, options);
                    case "user": return UserChatMessage.DeserializeUserChatMessage(element, options);
                }
            }
            return InternalUnknownChatMessage.DeserializeInternalUnknownChatMessage(element, options);
        }

        BinaryData IPersistableModel<ChatMessage>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChatMessage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ChatMessage)} does not support writing '{options.Format}' format.");
            }
        }

        ChatMessage IPersistableModel<ChatMessage>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ChatMessage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeChatMessage(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ChatMessage)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ChatMessage>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        internal static ChatMessage FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeChatMessage(document.RootElement);
        }

        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
