// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Text.Json;

namespace Robotless.Modules.OpenAi.RealtimeConversation
{
    [PersistableModelProxy(typeof(UnknownRealtimeContentPart))]
    public partial class ConversationContentPart : IJsonModel<ConversationContentPart>
    {
        void IJsonModel<ConversationContentPart>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationContentPart>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationContentPart)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (SerializedAdditionalRawData?.ContainsKey("type") != true)
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(Kind.ToString());
            }
            if (SerializedAdditionalRawData != null)
            {
                foreach (var item in SerializedAdditionalRawData)
                {
                    if (ModelSerializationExtensions.IsSentinelValue(item.Value))
                    {
                        continue;
                    }
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }

        ConversationContentPart IJsonModel<ConversationContentPart>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationContentPart>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationContentPart)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConversationContentPart(document.RootElement, options);
        }

        internal static ConversationContentPart DeserializeConversationContentPart(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("type", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "audio": return InternalRealtimeResponseAudioContentPart.DeserializeInternalRealtimeResponseAudioContentPart(element, options);
                    case "input_audio": return InternalRealtimeRequestAudioContentPart.DeserializeInternalRealtimeRequestAudioContentPart(element, options);
                    case "input_text": return InternalRealtimeRequestTextContentPart.DeserializeInternalRealtimeRequestTextContentPart(element, options);
                    case "text": return InternalRealtimeResponseTextContentPart.DeserializeInternalRealtimeResponseTextContentPart(element, options);
                }
            }
            return UnknownRealtimeContentPart.DeserializeUnknownRealtimeContentPart(element, options);
        }

        BinaryData IPersistableModel<ConversationContentPart>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationContentPart>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConversationContentPart)} does not support writing '{options.Format}' format.");
            }
        }

        ConversationContentPart IPersistableModel<ConversationContentPart>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationContentPart>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConversationContentPart(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConversationContentPart)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConversationContentPart>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        internal static ConversationContentPart FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeConversationContentPart(document.RootElement);
        }

        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
