// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Robotless.Modules.OpenAi.RealtimeConversation
{
    public readonly partial struct ConversationItemStatus : IEquatable<ConversationItemStatus>
    {
        private readonly string _value;

        public ConversationItemStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "in_progress";
        private const string CompletedValue = "completed";
        private const string IncompleteValue = "incomplete";

        public static ConversationItemStatus InProgress { get; } = new ConversationItemStatus(InProgressValue);
        public static ConversationItemStatus Completed { get; } = new ConversationItemStatus(CompletedValue);
        public static ConversationItemStatus Incomplete { get; } = new ConversationItemStatus(IncompleteValue);
        public static bool operator ==(ConversationItemStatus left, ConversationItemStatus right) => left.Equals(right);
        public static bool operator !=(ConversationItemStatus left, ConversationItemStatus right) => !left.Equals(right);
        public static implicit operator ConversationItemStatus(string value) => new ConversationItemStatus(value);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConversationItemStatus other && Equals(other);
        public bool Equals(ConversationItemStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        public override string ToString() => _value;
    }
}
