// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Robotless.Modules.OpenAi.RealtimeConversation
{
    public readonly partial struct ConversationMessageRole : IEquatable<ConversationMessageRole>
    {
        private readonly string _value;

        public ConversationMessageRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemValue = "system";
        private const string UserValue = "user";
        private const string AssistantValue = "assistant";

        public static ConversationMessageRole System { get; } = new ConversationMessageRole(SystemValue);
        public static ConversationMessageRole User { get; } = new ConversationMessageRole(UserValue);
        public static ConversationMessageRole Assistant { get; } = new ConversationMessageRole(AssistantValue);
        public static bool operator ==(ConversationMessageRole left, ConversationMessageRole right) => left.Equals(right);
        public static bool operator !=(ConversationMessageRole left, ConversationMessageRole right) => !left.Equals(right);
        public static implicit operator ConversationMessageRole(string value) => new ConversationMessageRole(value);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConversationMessageRole other && Equals(other);
        public bool Equals(ConversationMessageRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        public override string ToString() => _value;
    }
}
