// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;

namespace Robotless.Modules.OpenAi.RealtimeConversation
{
    public partial class ConversationTokenUsage : IJsonModel<ConversationTokenUsage>
    {
        void IJsonModel<ConversationTokenUsage>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationTokenUsage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationTokenUsage)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (SerializedAdditionalRawData?.ContainsKey("total_tokens") != true)
            {
                writer.WritePropertyName("total_tokens"u8);
                writer.WriteNumberValue(TotalTokens);
            }
            if (SerializedAdditionalRawData?.ContainsKey("input_tokens") != true)
            {
                writer.WritePropertyName("input_tokens"u8);
                writer.WriteNumberValue(InputTokens);
            }
            if (SerializedAdditionalRawData?.ContainsKey("output_tokens") != true)
            {
                writer.WritePropertyName("output_tokens"u8);
                writer.WriteNumberValue(OutputTokens);
            }
            if (SerializedAdditionalRawData?.ContainsKey("input_token_details") != true)
            {
                writer.WritePropertyName("input_token_details"u8);
                writer.WriteObjectValue(InputTokenDetails, options);
            }
            if (SerializedAdditionalRawData?.ContainsKey("output_token_details") != true)
            {
                writer.WritePropertyName("output_token_details"u8);
                writer.WriteObjectValue(OutputTokenDetails, options);
            }
            if (SerializedAdditionalRawData != null)
            {
                foreach (var item in SerializedAdditionalRawData)
                {
                    if (ModelSerializationExtensions.IsSentinelValue(item.Value))
                    {
                        continue;
                    }
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }

        ConversationTokenUsage IJsonModel<ConversationTokenUsage>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationTokenUsage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConversationTokenUsage)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConversationTokenUsage(document.RootElement, options);
        }

        internal static ConversationTokenUsage DeserializeConversationTokenUsage(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int totalTokens = default;
            int inputTokens = default;
            int outputTokens = default;
            ConversationInputTokenUsageDetails inputTokenDetails = default;
            ConversationOutputTokenUsageDetails outputTokenDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("total_tokens"u8))
                {
                    totalTokens = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("input_tokens"u8))
                {
                    inputTokens = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("output_tokens"u8))
                {
                    outputTokens = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("input_token_details"u8))
                {
                    inputTokenDetails = ConversationInputTokenUsageDetails.DeserializeConversationInputTokenUsageDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("output_token_details"u8))
                {
                    outputTokenDetails = ConversationOutputTokenUsageDetails.DeserializeConversationOutputTokenUsageDetails(property.Value, options);
                    continue;
                }
                if (true)
                {
                    rawDataDictionary ??= new Dictionary<string, BinaryData>();
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConversationTokenUsage(
                totalTokens,
                inputTokens,
                outputTokens,
                inputTokenDetails,
                outputTokenDetails,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConversationTokenUsage>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationTokenUsage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConversationTokenUsage)} does not support writing '{options.Format}' format.");
            }
        }

        ConversationTokenUsage IPersistableModel<ConversationTokenUsage>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConversationTokenUsage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConversationTokenUsage(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConversationTokenUsage)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConversationTokenUsage>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        internal static ConversationTokenUsage FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeConversationTokenUsage(document.RootElement);
        }

        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
