// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Robotless.Modules.OpenAi.RealtimeConversation
{
    public readonly partial struct ConversationVoice : IEquatable<ConversationVoice>
    {
        private readonly string _value;

        public ConversationVoice(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlloyValue = "alloy";
        private const string ShimmerValue = "shimmer";
        private const string EchoValue = "echo";

        public static ConversationVoice Alloy { get; } = new ConversationVoice(AlloyValue);
        public static ConversationVoice Shimmer { get; } = new ConversationVoice(ShimmerValue);
        public static ConversationVoice Echo { get; } = new ConversationVoice(EchoValue);
        public static bool operator ==(ConversationVoice left, ConversationVoice right) => left.Equals(right);
        public static bool operator !=(ConversationVoice left, ConversationVoice right) => !left.Equals(right);
        public static implicit operator ConversationVoice(string value) => new ConversationVoice(value);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConversationVoice other && Equals(other);
        public bool Equals(ConversationVoice other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        public override string ToString() => _value;
    }
}
