// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;

namespace Robotless.Modules.OpenAi.FineTuning
{
    internal partial class InternalFineTuningJobCheckpoint : IJsonModel<InternalFineTuningJobCheckpoint>
    {
        void IJsonModel<InternalFineTuningJobCheckpoint>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalFineTuningJobCheckpoint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalFineTuningJobCheckpoint)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (SerializedAdditionalRawData?.ContainsKey("id") != true)
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (SerializedAdditionalRawData?.ContainsKey("created_at") != true)
            {
                writer.WritePropertyName("created_at"u8);
                writer.WriteNumberValue(CreatedAt, "U");
            }
            if (SerializedAdditionalRawData?.ContainsKey("fine_tuned_model_checkpoint") != true)
            {
                writer.WritePropertyName("fine_tuned_model_checkpoint"u8);
                writer.WriteStringValue(FineTunedModelCheckpoint);
            }
            if (SerializedAdditionalRawData?.ContainsKey("step_number") != true)
            {
                writer.WritePropertyName("step_number"u8);
                writer.WriteNumberValue(StepNumber);
            }
            if (SerializedAdditionalRawData?.ContainsKey("metrics") != true)
            {
                writer.WritePropertyName("metrics"u8);
                writer.WriteObjectValue(Metrics, options);
            }
            if (SerializedAdditionalRawData?.ContainsKey("fine_tuning_job_id") != true)
            {
                writer.WritePropertyName("fine_tuning_job_id"u8);
                writer.WriteStringValue(FineTuningJobId);
            }
            if (SerializedAdditionalRawData?.ContainsKey("object") != true)
            {
                writer.WritePropertyName("object"u8);
                writer.WriteStringValue(Object.ToString());
            }
            if (SerializedAdditionalRawData != null)
            {
                foreach (var item in SerializedAdditionalRawData)
                {
                    if (ModelSerializationExtensions.IsSentinelValue(item.Value))
                    {
                        continue;
                    }
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }

        InternalFineTuningJobCheckpoint IJsonModel<InternalFineTuningJobCheckpoint>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalFineTuningJobCheckpoint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalFineTuningJobCheckpoint)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInternalFineTuningJobCheckpoint(document.RootElement, options);
        }

        internal static InternalFineTuningJobCheckpoint DeserializeInternalFineTuningJobCheckpoint(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            DateTimeOffset createdAt = default;
            string fineTunedModelCheckpoint = default;
            int stepNumber = default;
            InternalFineTuningJobCheckpointMetrics metrics = default;
            string fineTuningJobId = default;
            InternalFineTuningJobCheckpointObject @object = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("created_at"u8))
                {
                    createdAt = DateTimeOffset.FromUnixTimeSeconds(property.Value.GetInt64());
                    continue;
                }
                if (property.NameEquals("fine_tuned_model_checkpoint"u8))
                {
                    fineTunedModelCheckpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("step_number"u8))
                {
                    stepNumber = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("metrics"u8))
                {
                    metrics = InternalFineTuningJobCheckpointMetrics.DeserializeInternalFineTuningJobCheckpointMetrics(property.Value, options);
                    continue;
                }
                if (property.NameEquals("fine_tuning_job_id"u8))
                {
                    fineTuningJobId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("object"u8))
                {
                    @object = new InternalFineTuningJobCheckpointObject(property.Value.GetString());
                    continue;
                }
                if (true)
                {
                    rawDataDictionary ??= new Dictionary<string, BinaryData>();
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InternalFineTuningJobCheckpoint(
                id,
                createdAt,
                fineTunedModelCheckpoint,
                stepNumber,
                metrics,
                fineTuningJobId,
                @object,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<InternalFineTuningJobCheckpoint>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalFineTuningJobCheckpoint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InternalFineTuningJobCheckpoint)} does not support writing '{options.Format}' format.");
            }
        }

        InternalFineTuningJobCheckpoint IPersistableModel<InternalFineTuningJobCheckpoint>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalFineTuningJobCheckpoint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInternalFineTuningJobCheckpoint(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InternalFineTuningJobCheckpoint)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InternalFineTuningJobCheckpoint>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        internal static InternalFineTuningJobCheckpoint FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeInternalFineTuningJobCheckpoint(document.RootElement);
        }

        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
