// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Text.Json;

namespace Robotless.Modules.OpenAi.RealtimeConversation
{
    [PersistableModelProxy(typeof(UnknownRealtimeClientEvent))]
    internal partial class InternalRealtimeClientEvent : IJsonModel<InternalRealtimeClientEvent>
    {
        void IJsonModel<InternalRealtimeClientEvent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeClientEvent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalRealtimeClientEvent)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (SerializedAdditionalRawData?.ContainsKey("type") != true)
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(Kind.ToString());
            }
            if (SerializedAdditionalRawData?.ContainsKey("event_id") != true && Optional.IsDefined(EventId))
            {
                writer.WritePropertyName("event_id"u8);
                writer.WriteStringValue(EventId);
            }
            if (SerializedAdditionalRawData != null)
            {
                foreach (var item in SerializedAdditionalRawData)
                {
                    if (ModelSerializationExtensions.IsSentinelValue(item.Value))
                    {
                        continue;
                    }
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }

        InternalRealtimeClientEvent IJsonModel<InternalRealtimeClientEvent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeClientEvent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalRealtimeClientEvent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInternalRealtimeClientEvent(document.RootElement, options);
        }

        internal static InternalRealtimeClientEvent DeserializeInternalRealtimeClientEvent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("type", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "conversation.item.create": return InternalRealtimeClientEventConversationItemCreate.DeserializeInternalRealtimeClientEventConversationItemCreate(element, options);
                    case "conversation.item.delete": return InternalRealtimeClientEventConversationItemDelete.DeserializeInternalRealtimeClientEventConversationItemDelete(element, options);
                    case "conversation.item.truncate": return InternalRealtimeClientEventConversationItemTruncate.DeserializeInternalRealtimeClientEventConversationItemTruncate(element, options);
                    case "input_audio_buffer.append": return InternalRealtimeClientEventInputAudioBufferAppend.DeserializeInternalRealtimeClientEventInputAudioBufferAppend(element, options);
                    case "input_audio_buffer.clear": return InternalRealtimeClientEventInputAudioBufferClear.DeserializeInternalRealtimeClientEventInputAudioBufferClear(element, options);
                    case "input_audio_buffer.commit": return InternalRealtimeClientEventInputAudioBufferCommit.DeserializeInternalRealtimeClientEventInputAudioBufferCommit(element, options);
                    case "response.cancel": return InternalRealtimeClientEventResponseCancel.DeserializeInternalRealtimeClientEventResponseCancel(element, options);
                    case "response.create": return InternalRealtimeClientEventResponseCreate.DeserializeInternalRealtimeClientEventResponseCreate(element, options);
                    case "session.update": return InternalRealtimeClientEventSessionUpdate.DeserializeInternalRealtimeClientEventSessionUpdate(element, options);
                }
            }
            return UnknownRealtimeClientEvent.DeserializeUnknownRealtimeClientEvent(element, options);
        }

        BinaryData IPersistableModel<InternalRealtimeClientEvent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeClientEvent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InternalRealtimeClientEvent)} does not support writing '{options.Format}' format.");
            }
        }

        InternalRealtimeClientEvent IPersistableModel<InternalRealtimeClientEvent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeClientEvent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInternalRealtimeClientEvent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InternalRealtimeClientEvent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InternalRealtimeClientEvent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        internal static InternalRealtimeClientEvent FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeInternalRealtimeClientEvent(document.RootElement);
        }

        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
