// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;

namespace Robotless.Modules.OpenAi.RealtimeConversation
{
    internal partial class InternalRealtimeResponseSession : IJsonModel<InternalRealtimeResponseSession>
    {
        void IJsonModel<InternalRealtimeResponseSession>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeResponseSession>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalRealtimeResponseSession)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (SerializedAdditionalRawData?.ContainsKey("object") != true)
            {
                writer.WritePropertyName("object"u8);
                writer.WriteStringValue(Object.ToString());
            }
            if (SerializedAdditionalRawData?.ContainsKey("id") != true)
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (SerializedAdditionalRawData?.ContainsKey("model") != true)
            {
                writer.WritePropertyName("model"u8);
                writer.WriteStringValue(Model);
            }
            if (SerializedAdditionalRawData?.ContainsKey("modalities") != true)
            {
                writer.WritePropertyName("modalities"u8);
                writer.WriteStartArray();
                foreach (var item in Modalities)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (SerializedAdditionalRawData?.ContainsKey("instructions") != true)
            {
                writer.WritePropertyName("instructions"u8);
                writer.WriteStringValue(Instructions);
            }
            if (SerializedAdditionalRawData?.ContainsKey("voice") != true)
            {
                writer.WritePropertyName("voice"u8);
                writer.WriteStringValue(Voice.ToString());
            }
            if (SerializedAdditionalRawData?.ContainsKey("input_audio_format") != true)
            {
                writer.WritePropertyName("input_audio_format"u8);
                writer.WriteStringValue(InputAudioFormat.ToString());
            }
            if (SerializedAdditionalRawData?.ContainsKey("output_audio_format") != true)
            {
                writer.WritePropertyName("output_audio_format"u8);
                writer.WriteStringValue(OutputAudioFormat.ToString());
            }
            if (SerializedAdditionalRawData?.ContainsKey("input_audio_transcription") != true)
            {
                if (InputAudioTranscription != null)
                {
                    writer.WritePropertyName("input_audio_transcription"u8);
                    writer.WriteObjectValue(InputAudioTranscription, options);
                }
                else
                {
                    writer.WriteNull("input_audio_transcription");
                }
            }
            if (SerializedAdditionalRawData?.ContainsKey("turn_detection") != true)
            {
                writer.WritePropertyName("turn_detection"u8);
                writer.WriteObjectValue(TurnDetection, options);
            }
            if (SerializedAdditionalRawData?.ContainsKey("tools") != true)
            {
                writer.WritePropertyName("tools"u8);
                writer.WriteStartArray();
                foreach (var item in Tools)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (SerializedAdditionalRawData?.ContainsKey("tool_choice") != true)
            {
                writer.WritePropertyName("tool_choice"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(ToolChoice);
#else
                using (JsonDocument document = JsonDocument.Parse(ToolChoice))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (SerializedAdditionalRawData?.ContainsKey("temperature") != true)
            {
                writer.WritePropertyName("temperature"u8);
                writer.WriteNumberValue(Temperature);
            }
            if (SerializedAdditionalRawData?.ContainsKey("max_response_output_tokens") != true)
            {
                if (_maxResponseOutputTokens != null)
                {
                    writer.WritePropertyName("max_response_output_tokens"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(_maxResponseOutputTokens);
#else
                    using (JsonDocument document = JsonDocument.Parse(_maxResponseOutputTokens))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                else
                {
                    writer.WriteNull("max_response_output_tokens");
                }
            }
            if (SerializedAdditionalRawData != null)
            {
                foreach (var item in SerializedAdditionalRawData)
                {
                    if (ModelSerializationExtensions.IsSentinelValue(item.Value))
                    {
                        continue;
                    }
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }

        InternalRealtimeResponseSession IJsonModel<InternalRealtimeResponseSession>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeResponseSession>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalRealtimeResponseSession)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInternalRealtimeResponseSession(document.RootElement, options);
        }

        internal static InternalRealtimeResponseSession DeserializeInternalRealtimeResponseSession(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            InternalRealtimeResponseSessionObject @object = default;
            string id = default;
            string model = default;
            IReadOnlyList<InternalRealtimeRequestSessionModality> modalities = default;
            string instructions = default;
            ConversationVoice voice = default;
            ConversationAudioFormat inputAudioFormat = default;
            ConversationAudioFormat outputAudioFormat = default;
            ConversationInputTranscriptionOptions inputAudioTranscription = default;
            ConversationTurnDetectionOptions turnDetection = default;
            IReadOnlyList<ConversationTool> tools = default;
            BinaryData toolChoice = default;
            float temperature = default;
            BinaryData maxResponseOutputTokens = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("object"u8))
                {
                    @object = new InternalRealtimeResponseSessionObject(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("model"u8))
                {
                    model = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("modalities"u8))
                {
                    List<InternalRealtimeRequestSessionModality> array = new List<InternalRealtimeRequestSessionModality>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new InternalRealtimeRequestSessionModality(item.GetString()));
                    }
                    modalities = array;
                    continue;
                }
                if (property.NameEquals("instructions"u8))
                {
                    instructions = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("voice"u8))
                {
                    voice = new ConversationVoice(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("input_audio_format"u8))
                {
                    inputAudioFormat = new ConversationAudioFormat(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("output_audio_format"u8))
                {
                    outputAudioFormat = new ConversationAudioFormat(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("input_audio_transcription"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        inputAudioTranscription = null;
                        continue;
                    }
                    inputAudioTranscription = ConversationInputTranscriptionOptions.DeserializeConversationInputTranscriptionOptions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("turn_detection"u8))
                {
                    turnDetection = ConversationTurnDetectionOptions.DeserializeConversationTurnDetectionOptions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tools"u8))
                {
                    List<ConversationTool> array = new List<ConversationTool>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ConversationTool.DeserializeConversationTool(item, options));
                    }
                    tools = array;
                    continue;
                }
                if (property.NameEquals("tool_choice"u8))
                {
                    toolChoice = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("temperature"u8))
                {
                    temperature = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("max_response_output_tokens"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        maxResponseOutputTokens = null;
                        continue;
                    }
                    maxResponseOutputTokens = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (true)
                {
                    rawDataDictionary ??= new Dictionary<string, BinaryData>();
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InternalRealtimeResponseSession(
                @object,
                id,
                model,
                modalities,
                instructions,
                voice,
                inputAudioFormat,
                outputAudioFormat,
                inputAudioTranscription,
                turnDetection,
                tools,
                toolChoice,
                temperature,
                maxResponseOutputTokens,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<InternalRealtimeResponseSession>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeResponseSession>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InternalRealtimeResponseSession)} does not support writing '{options.Format}' format.");
            }
        }

        InternalRealtimeResponseSession IPersistableModel<InternalRealtimeResponseSession>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalRealtimeResponseSession>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInternalRealtimeResponseSession(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InternalRealtimeResponseSession)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InternalRealtimeResponseSession>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        internal static InternalRealtimeResponseSession FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeInternalRealtimeResponseSession(document.RootElement);
        }

        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
