// <auto-generated/>

#nullable disable

using System;
using System.ClientModel;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;

namespace Robotless.Modules.OpenAi.VectorStores
{
    internal partial class InternalStaticChunkingStrategyDetails : IJsonModel<InternalStaticChunkingStrategyDetails>
    {
        void IJsonModel<InternalStaticChunkingStrategyDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalStaticChunkingStrategyDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalStaticChunkingStrategyDetails)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (SerializedAdditionalRawData?.ContainsKey("max_chunk_size_tokens") != true)
            {
                writer.WritePropertyName("max_chunk_size_tokens"u8);
                writer.WriteNumberValue(MaxChunkSizeTokens);
            }
            if (SerializedAdditionalRawData?.ContainsKey("chunk_overlap_tokens") != true)
            {
                writer.WritePropertyName("chunk_overlap_tokens"u8);
                writer.WriteNumberValue(ChunkOverlapTokens);
            }
            if (SerializedAdditionalRawData != null)
            {
                foreach (var item in SerializedAdditionalRawData)
                {
                    if (ModelSerializationExtensions.IsSentinelValue(item.Value))
                    {
                        continue;
                    }
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }

        InternalStaticChunkingStrategyDetails IJsonModel<InternalStaticChunkingStrategyDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalStaticChunkingStrategyDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InternalStaticChunkingStrategyDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInternalStaticChunkingStrategyDetails(document.RootElement, options);
        }

        internal static InternalStaticChunkingStrategyDetails DeserializeInternalStaticChunkingStrategyDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int maxChunkSizeTokens = default;
            int chunkOverlapTokens = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("max_chunk_size_tokens"u8))
                {
                    maxChunkSizeTokens = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("chunk_overlap_tokens"u8))
                {
                    chunkOverlapTokens = property.Value.GetInt32();
                    continue;
                }
                if (true)
                {
                    rawDataDictionary ??= new Dictionary<string, BinaryData>();
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InternalStaticChunkingStrategyDetails(maxChunkSizeTokens, chunkOverlapTokens, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<InternalStaticChunkingStrategyDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalStaticChunkingStrategyDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(InternalStaticChunkingStrategyDetails)} does not support writing '{options.Format}' format.");
            }
        }

        InternalStaticChunkingStrategyDetails IPersistableModel<InternalStaticChunkingStrategyDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InternalStaticChunkingStrategyDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInternalStaticChunkingStrategyDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InternalStaticChunkingStrategyDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InternalStaticChunkingStrategyDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        internal static InternalStaticChunkingStrategyDetails FromResponse(PipelineResponse response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeInternalStaticChunkingStrategyDetails(document.RootElement);
        }

        internal virtual BinaryContent ToBinaryContent()
        {
            return BinaryContent.Create(this, ModelSerializationExtensions.WireOptions);
        }
    }
}
