// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Robotless.Modules.OpenAi.Assistants
{
    public readonly partial struct RunErrorCode : IEquatable<RunErrorCode>
    {
        private readonly string _value;

        public RunErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServerErrorValue = "server_error";
        private const string RateLimitExceededValue = "rate_limit_exceeded";
        private const string InvalidPromptValue = "invalid_prompt";

        public static RunErrorCode ServerError { get; } = new RunErrorCode(ServerErrorValue);
        public static RunErrorCode RateLimitExceeded { get; } = new RunErrorCode(RateLimitExceededValue);
        public static RunErrorCode InvalidPrompt { get; } = new RunErrorCode(InvalidPromptValue);
        public static bool operator ==(RunErrorCode left, RunErrorCode right) => left.Equals(right);
        public static bool operator !=(RunErrorCode left, RunErrorCode right) => !left.Equals(right);
        public static implicit operator RunErrorCode(string value) => new RunErrorCode(value);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RunErrorCode other && Equals(other);
        public bool Equals(RunErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        public override string ToString() => _value;
    }
}
