// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Robotless.Modules.OpenAi.Assistants
{
    public readonly partial struct RunStatus : IEquatable<RunStatus>
    {
        private readonly string _value;

        public RunStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueuedValue = "queued";
        private const string InProgressValue = "in_progress";
        private const string RequiresActionValue = "requires_action";
        private const string CancellingValue = "cancelling";
        private const string CancelledValue = "cancelled";
        private const string FailedValue = "failed";
        private const string CompletedValue = "completed";
        private const string IncompleteValue = "incomplete";
        private const string ExpiredValue = "expired";

        public static RunStatus Queued { get; } = new RunStatus(QueuedValue);
        public static RunStatus InProgress { get; } = new RunStatus(InProgressValue);
        public static RunStatus RequiresAction { get; } = new RunStatus(RequiresActionValue);
        public static RunStatus Cancelling { get; } = new RunStatus(CancellingValue);
        public static RunStatus Cancelled { get; } = new RunStatus(CancelledValue);
        public static RunStatus Failed { get; } = new RunStatus(FailedValue);
        public static RunStatus Completed { get; } = new RunStatus(CompletedValue);
        public static RunStatus Incomplete { get; } = new RunStatus(IncompleteValue);
        public static RunStatus Expired { get; } = new RunStatus(ExpiredValue);
        public static bool operator ==(RunStatus left, RunStatus right) => left.Equals(right);
        public static bool operator !=(RunStatus left, RunStatus right) => !left.Equals(right);
        public static implicit operator RunStatus(string value) => new RunStatus(value);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RunStatus other && Equals(other);
        public bool Equals(RunStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        public override string ToString() => _value;
    }
}
