// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Robotless.Modules.OpenAi.Assistants
{
    public readonly partial struct RunStepStatus : IEquatable<RunStepStatus>
    {
        private readonly string _value;

        public RunStepStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "in_progress";
        private const string CancelledValue = "cancelled";
        private const string FailedValue = "failed";
        private const string CompletedValue = "completed";
        private const string ExpiredValue = "expired";

        public static RunStepStatus InProgress { get; } = new RunStepStatus(InProgressValue);
        public static RunStepStatus Cancelled { get; } = new RunStepStatus(CancelledValue);
        public static RunStepStatus Failed { get; } = new RunStepStatus(FailedValue);
        public static RunStepStatus Completed { get; } = new RunStepStatus(CompletedValue);
        public static RunStepStatus Expired { get; } = new RunStepStatus(ExpiredValue);
        public static bool operator ==(RunStepStatus left, RunStepStatus right) => left.Equals(right);
        public static bool operator !=(RunStepStatus left, RunStepStatus right) => !left.Equals(right);
        public static implicit operator RunStepStatus(string value) => new RunStepStatus(value);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RunStepStatus other && Equals(other);
        public bool Equals(RunStepStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        public override string ToString() => _value;
    }
}
