using System;

namespace Robotless.Modules.OpenAi;

internal static class AppContextSwitchHelper
{
    /// <summary>
    /// Determines if either an AppContext switch or its corresponding Environment Variable is set
    /// </summary>
    /// <param name="appContextSwitchName">Name of the AppContext switch.</param>
    /// <param name="environmentVariableName">Name of the Environment variable.</param>
    /// <returns>If the AppContext switch has been set, returns the value of the switch.
    /// If the AppContext switch has not been set, returns the value of the environment variable.
    /// False if neither is set.
    /// </returns>
    public static bool GetConfigValue(string appContextSwitchName, string environmentVariableName)
    {
        // First check for the AppContext switch, giving it priority over the environment variable.
        if (AppContext.TryGetSwitch(appContextSwitchName, out bool value))
        {
            return value;
        }
        // AppContext switch wasn't used. Check the environment variable.
        string envVar = Environment.GetEnvironmentVariable(environmentVariableName);
        if (envVar != null && (envVar.Equals("true", StringComparison.OrdinalIgnoreCase) || envVar.Equals("1")))
        {
            return true;
        }

        // Default to false.
        return false;
    }
}
