using Robotless.Kernel;
using Robotless.Modules.Annotations;
using Robotless.Modules.Injecting;

namespace Robotless.Framework;

public abstract class Component : WorkspaceObject
{
    /// <summary>
    /// Entity that this object attached to.
    /// </summary>
    public required Entity Entity { get; init; }

    public string AuthorName { get; set; }

    /// <summary>
    /// This method is called after this object is attached to an entity.
    /// </summary>
    [DynamicallyInvoked]
    protected virtual void OnAttach() {}
    
    /// <summary>
    /// This method is called after this object is detached from the entity.
    /// </summary>
    [DynamicallyInvoked]
    protected virtual void OnDetach() {}
}

[AttributeUsage(AttributeTargets.Field | AttributeTargets.Property)]
public class ComponentInjectionAttribute : InjectionAttribute
{
    /// <summary>
    /// If the entity does not have the required component, and this property is set to true,
    /// then the component will be attached to this entity.
    /// </summary>
    public bool IsEnsured { get; set; } = false;
}