using System.Collections.ObjectModel;

namespace Robotless.Kernel;

public class HierarchyNode<TValue>
{
    public TValue Value { get; }

    public HierarchyNode<TValue>? Parent
    {
        get;
        private set
        {
            if (field == value)
                return;
            field?._children.Remove(this);
            if (value == null)
                return;
            field = value;
            value._children.Add(this);
        }
    }

    private readonly HashSet<HierarchyNode<TValue>> _children;
    
    public IReadOnlySet<HierarchyNode<TValue>> Children { get; }
    
    public HierarchyNode(TValue value)
    {
        Value = value;
        _children = [];
        Children = new ReadOnlySet<HierarchyNode<TValue>>(_children);
    }
}