using Robotless.Framework;
using Robotless.Modules.Injecting;

namespace Robotless.Kernel.Utilities;

public class EnsuredComponentProvider : IInjectionProvider
{
    public static EnsuredComponentProvider Instance { get; } = new();
    
    private EnsuredComponentProvider()
    {}
    
    public object? GetInjection(Type type, object? key = default, InjectionRequester requester = default)
    {
        // This method will only work for entities in member injection.
        if (requester.Instance is not Entity entity || requester.Member == null)
            return null;
        var attribute = requester.GetAttribute<ComponentDependencyAttribute>();
        return attribute?.IsEnsuring == true ? entity.EnsureComponent(type) : entity.GetComponent(type);
    }

    public IInjectionProvider NewScope() => this;
}