using Robotless.Modules.Annotations;

namespace Robotless.Kernel;

/// <summary>
/// Base class for workspace services.
/// These services are managed by the workspace, and usually have the same lifetime as the workspace.
/// </summary>
public class WorkspaceService : IService
{
    public Guid Identifier { get; private set; } = Guid.CreateVersion7();
    
    /// <summary>
    /// Invoked when the workspace has been started.
    /// </summary>
    [DynamicallyInvoked("Invoked by the workspace when it is started.")]
    protected virtual Task Startup()
        => Task.CompletedTask;

    /// <summary>
    /// Invoked when the workspace has been shutdown.
    /// </summary>
    [DynamicallyInvoked("Invoked by the workspace when it is shutdown.")]
    protected virtual Task Shutdown()
        => Task.CompletedTask;
}