using JetBrains.Annotations;

namespace Robotless.Modules.Annotations;

/// <summary>
/// The methods, properties, or fields marked with this attribute will be invoked dynamically.
/// </summary>
[AttributeUsage(AttributeTargets.Method | AttributeTargets.Property | AttributeTargets.Field,
     AllowMultiple = true),
 MeansImplicitUse(ImplicitUseKindFlags.Access)]
public class DynamicallyInvokedAttribute(string? reasons = null) : Attribute
{
    public string? Reasons { get; } = null;
}