﻿using Robotless.Modules.Injecting;

namespace Robotless.Modules.Documenting;

public class DocumentationCollection : IDocumentation
{
    /// <summary>
    /// Registered providers that can provide documentation entries.
    /// </summary>
    public LinkedList<IDocumentation> Documentations { get; } = [];

    /// <inheritdoc cref="IDocumentation.GetEntry(string)"/>
    public IEntry? GetEntry(string entryName)
    {
        return Documentations.Select(provider => provider.GetEntry(entryName))
            .FirstOrDefault(entry => entry is not null);
    }
}

public static class DocumentationCollectionExtensions
{
    /// <summary>
    /// Add a documentation provider to the collection.
    /// </summary>
    /// <param name="container">Collection to add the provider to.</param>
    /// <param name="documentation">Provider to add to the collection.</param>
    public static TInjectionContainer AddDocumentation<TInjectionContainer>(
        this TInjectionContainer container, IDocumentation documentation)
        where TInjectionContainer : IInjectionContainer
    {
        var collection = container.GetInjection<DocumentationCollection>();
        if (collection == null)
        {
            collection = new DocumentationCollection();
            container.AddConstant(collection);
            container.AddRedirection<IDocumentation, DocumentationCollection>();
        }
        collection.Documentations.AddLast(documentation);
        return container;
    }
}