﻿using System.Reflection;

namespace Robotless.Modules.Documenting;

/// <summary>
/// Documentation is a collection of documentation entries.
/// </summary>
public interface IDocumentation
{
    /// <summary>
    /// Get the documentation entry for the specified entry name.
    /// Use <see cref="EntryName"/> to get the entry name according to reflection information.
    /// </summary>
    /// <param name="entryName">Formatted name of the entry.</param>
    /// <returns>Entry with the specified entry name, or null if not found.</returns>
    IEntry? GetEntry(string entryName);
}

public static class DocumentationEntryNameExtensions
{
    public static ITypeEntry? GetEntry(this IDocumentation fileDocumentation, Type type)
        => (ITypeEntry?)fileDocumentation.GetEntry(EntryName.Get(type));
    
    public static IMemberEntry? GetEntry(this IDocumentation fileDocumentation, MemberInfo member)
        => (IMemberEntry?)fileDocumentation.GetEntry(EntryName.Get(member));
    
    public static IMethodEntry? GetEntry(this IDocumentation fileDocumentation, MethodInfo method)
        => (IMethodEntry?)fileDocumentation.GetEntry(EntryName.Get(method));
    
    public static IMethodEntry? GetEntry(this IDocumentation fileDocumentation, ConstructorInfo constructor)
        => (IMethodEntry?)fileDocumentation.GetEntry(EntryName.Get(constructor));
    
    public static IMemberEntry? GetEntry(this IDocumentation fileDocumentation, FieldInfo field)
        => (IMemberEntry?)fileDocumentation.GetEntry(EntryName.Get(field));
    
    public static IMemberEntry? GetEntry(this IDocumentation fileDocumentation, PropertyInfo property)
        => (IMemberEntry?)fileDocumentation.GetEntry(EntryName.Get(property));
    
    public static IMemberEntry? GetEntry(this IDocumentation fileDocumentation, EventInfo @event)
        => (IMemberEntry?)fileDocumentation.GetEntry(EntryName.Get(@event));
}