namespace Robotless.Modules.Eventing;

public interface IKeyedWeakEvent<in TKey, in TDelegate> where TKey : notnull where TDelegate : Delegate
{
    /// <summary>
    /// Add an event handler to the handler list.
    /// </summary>
    /// <param name="key">Key of the event.</param>
    /// <param name="owner">Object which owns this event handler.</param>
    /// <param name="handler">Event handler to add.</param>
    void Add(TKey key, object owner, TDelegate handler);

    /// <summary>
    /// Remove an event handler from the handler list.
    /// </summary>
    /// <param name="key">Key of the event.</param>
    /// <param name="owner">Object which owns this event handler.</param>
    /// <param name="handler">Event handler to remove.</param>
    /// <returns>
    /// True if a handler is removed, otherwise false.
    /// </returns>
    bool Remove(TKey key, object owner, TDelegate handler);

    /// <summary>
    /// Remove all event handlers owned by the specified object from the list with the specified key.
    /// </summary>
    /// <param name="key">Key of the event.</param>
    /// <param name="owner">Object which owns this event handler.</param>
    /// <returns>
    /// True if a handler is removed, otherwise false.
    /// </returns>
    bool Remove(TKey key, object owner);
    
    /// <summary>
    /// Remove all event handlers owned by the specified object.
    /// </summary>
    /// <param name="owner">Object whose event handlers will be removed.</param>
    /// <returns>
    /// True if any handler of the specified object is removed, otherwise false.
    /// </returns>
    bool Remove(object owner);
}