﻿namespace Robotless.Modules.Eventing;

/// <summary>
/// A weak event will add a reference handle to the event handler only when the owner of the handler is alive.
/// </summary>
/// <typeparam name="TDelegate">Delegate of event handlers.</typeparam>
public interface IWeakEvent<in TDelegate> where TDelegate : Delegate
{
    /// <summary>
    /// Add an event handler to the handler list.
    /// </summary>
    /// <param name="owner">Object which owns this event handler.</param>
    /// <param name="handler">Event handler to add.</param>
    void Add(object owner, TDelegate handler);
    
    /// <summary>
    /// Remove an event handler from the handler list.
    /// </summary>
    /// <param name="owner">Object which owns this event handler.</param>
    /// <param name="handler">Event handler to remove.</param>
    /// <returns>
    /// True if a handler is removed, otherwise false.
    /// </returns>
    bool Remove(object owner, TDelegate handler);
    
    /// <summary>
    /// Remove all event handlers owned by the specified object.
    /// </summary>
    /// <param name="owner">Object whose event handlers will be removed.</param>
    /// <returns>
    /// True if any handler of the specified object is removed, otherwise false.
    /// </returns>
    bool Remove(object owner);
}