using Microsoft.Extensions.DependencyInjection;

namespace Robotless.Modules.Injecting.Adapters;

public class ServiceProviderAdapter(IInjectionProvider provider) : IKeyedServiceProvider
{
    public object? GetService(Type serviceType)
        => provider.GetInjection(serviceType);

    public object? GetKeyedService(Type serviceType, object? serviceKey)
        => provider.GetInjection(serviceType, serviceKey);

    public object GetRequiredKeyedService(Type serviceType, object? serviceKey)
        => provider.RequireInjection(serviceType, serviceKey);
}

public static class ServiceProviderAdapterExtensions
{
    /// <summary>
    /// Create a wrapper to adapt the specified injection provider to a keyed service provider.
    /// </summary>
    /// <param name="provider">Injection provider to wrap.</param>
    /// <returns>Keyed service provider wrapper for the specified provider.</returns>
    public static IKeyedServiceProvider ToKeyedServiceProvider(this IInjectionProvider provider)
        => new ServiceProviderAdapter(provider);
}